<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIbanInquiriesTable extends Migration {

	public function up()
	{
		Schema::create('iban_inquiries', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('iban', 20)->index();
			$table->string('bank_first_name', 255)->nullable();
			$table->string('bank_last_name', 255)->nullable();
			$table->string('bank_account_number', 50)->nullable();
			$table->string('bank_account_status')->nullable();
			$table->string('bank_account_comment', 255)->nullable();
			$table->bigInteger('bank_id')->nullable()->default('0');
			$table->bigInteger('kook_id')->nullable()->default('0');
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('iban_inquiries');
	}
}