<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'Orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function invoices()
    {
        return $this->hasOne('Invoice');
    }

    public function Company()
    {
        return $this->belongsTo('Company');
    }

}