<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactInformationTable extends Migration {

	public function up()
	{
		Schema::create('contact_information', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('middle_initial', 1)->nullable();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('street_address');
			$table->string('city', 50);
			$table->string('primary_phone_number', 10);
			$table->string('primary_phone_extension', 10)->nullable();
			$table->enum('primary_phone_type', array('M', 'H', 'W'))->nullable();
			$table->string('secondary_phone_number', 10)->nullable();
			$table->string('secondary_phone_extension', 10)->nullable();
			$table->enum('secondary_phone_type', array('M', 'H', 'W'));
			$table->string('emergency_full_name')->nullable();
			$table->string('emergency_relationship', 30)->nullable();
			$table->string('emergency_primary_phone_number', 10)->nullable();
			$table->string('emergency_primary_phone_extension', 10)->nullable();
			$table->enum('emergency_primary_phone_type', array('M', 'H', 'W'))->nullable();
			$table->string('emergency_secondary_phone_number', 10)->nullable();
			$table->string('emergency_secondary_phone_extension', 10)->nullable();
			$table->string('emergency_secondary_phone_type')->nullable();
			$table->date('date_of_birth');
			$table->string('drivers_licence_number', 30);
			$table->string('drivers_licence_state', 2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contact_information');
	}
}