<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('login', 25)->unique();
			$table->string('password');
			$table->rememberToken();
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('company_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}