<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('owner_id', 'name_ar', 'name_en', 'image', 'location', 'capacity', 'is_active', 'has_volunteer', 'has_guests', 'start_at', 'end_at');

	public function owner()
	{
		return $this->belongsTo('App\Models\User', 'owner_id');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

}