<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EventVolunteer extends Eloquent {

	protected $table = 'event_volunteers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('event_id', 'volunteer_id', 'is_approved');

	public function event()
	{
		return $this->belongsTo('App\Models\Event');
	}

	public function volunteer()
	{
		return $this->belongsTo('App\Models\User', 'volunteer_id');
	}

}