<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('address');
			$table->string('address2')->nullable();
			$table->string('city', 50);
			$table->string('postal_code', 10);
			$table->integer('country');
			$table->integer('state');
			$table->string('phone', 20)->nullable();
			$table->string('mobile', 20)->nullable();
			$table->string('fax', 20)->nullable();
			$table->bigInteger('user_id');
			$table->datetime('dob')->nullable();
			$table->string('company', 1000)->nullable();
			$table->text('comments')->nullable();
			$table->tinyInteger('send_notification')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}