<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Groups extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group_has_many_category()
    {
        return $this->hasMany('Categories', 'group_id');
    }

    public function grup_user()
    {
        return $this->hasMany('GroupUser', 'group_id');
    }

}