<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tc_questions', function(Blueprint $table) {
			$table->foreign('tc_question_type_id')->references('id')->on('tc_question_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_forms', function(Blueprint $table) {
			$table->foreign('tc_question_id')->references('id')->on('tc_questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_forms', function(Blueprint $table) {
			$table->foreign('tc_form_type_id')->references('id')->on('tc_form_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_form_types', function(Blueprint $table) {
			$table->foreign('tc_stages_id')->references('id')->on('tc_stages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->foreign('tc_establishment_id')->references('id')->on('tc_establishment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->foreign('tc_form_id')->references('id')->on('tc_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->foreign('tc_question_id')->references('id')->on('tc_questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->foreign('tc_establishment_id')->references('id')->on('tc_establishment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->foreign('tc_path_id')->references('id')->on('tc_path')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->foreign('tc_form_id')->references('id')->on('tc_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_trips', function(Blueprint $table) {
			$table->foreign('tc_form_id')->references('id')->on('tc_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_trips', function(Blueprint $table) {
			$table->foreign('tc_establishment_id')->references('id')->on('tc_establishment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tc_operations', function(Blueprint $table) {
			$table->foreign('tc_stages_id')->references('id')->on('tc_stages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('arrival_paths', function(Blueprint $table) {
			$table->foreign('arrival_answer_id')->references('id')->on('arrival_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('moving_between_cities_paths', function(Blueprint $table) {
			$table->foreign('moving_between_cities_answer_id')->references('id')->on('moving_between_cities_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfer_pattern', function(Blueprint $table) {
			$table->foreign('moving_between_cities_answer_id')->references('id')->on('moving_between_cities_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performing_rituals_answer_paths', function(Blueprint $table) {
			$table->foreign('performing_rituals_answer_id')->references('id')->on('performing_rituals_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performing_rituals_answer_transfer_patterns', function(Blueprint $table) {
			$table->foreign('performing_rituals_answer_id')->references('id')->on('performing_rituals_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('performing_rituals_answer_trips', function(Blueprint $table) {
			$table->foreign('performing_rituals_answer_id')->references('id')->on('performing_rituals_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('arrival_transfer_pattern', function(Blueprint $table) {
			$table->foreign('arrival_answer_id')->references('id')->on('arrival_answers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('tc_questions', function(Blueprint $table) {
			$table->dropForeign('tc_questions_tc_question_type_id_foreign');
		});
		Schema::table('tc_forms', function(Blueprint $table) {
			$table->dropForeign('tc_forms_tc_question_id_foreign');
		});
		Schema::table('tc_forms', function(Blueprint $table) {
			$table->dropForeign('tc_forms_tc_form_type_id_foreign');
		});
		Schema::table('tc_form_types', function(Blueprint $table) {
			$table->dropForeign('tc_form_types_tc_stages_id_foreign');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->dropForeign('tc_question_answers_tc_establishment_id_foreign');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->dropForeign('tc_question_answers_tc_form_id_foreign');
		});
		Schema::table('tc_question_answers', function(Blueprint $table) {
			$table->dropForeign('tc_question_answers_tc_question_id_foreign');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->dropForeign('tc_option_lockup_tc_establishment_id_foreign');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->dropForeign('tc_option_lockup_tc_path_id_foreign');
		});
		Schema::table('tc_option_lockup', function(Blueprint $table) {
			$table->dropForeign('tc_option_lockup_tc_form_id_foreign');
		});
		Schema::table('tc_trips', function(Blueprint $table) {
			$table->dropForeign('tc_trips_tc_form_id_foreign');
		});
		Schema::table('tc_trips', function(Blueprint $table) {
			$table->dropForeign('tc_trips_tc_establishment_id_foreign');
		});
		Schema::table('tc_operations', function(Blueprint $table) {
			$table->dropForeign('tc_operations_tc_stages_id_foreign');
		});
		Schema::table('arrival_paths', function(Blueprint $table) {
			$table->dropForeign('arrival_paths_arrival_answer_id_foreign');
		});
		Schema::table('moving_between_cities_paths', function(Blueprint $table) {
			$table->dropForeign('moving_between_cities_paths_moving_between_cities_answer_id_foreign');
		});
		Schema::table('transfer_pattern', function(Blueprint $table) {
			$table->dropForeign('transfer_pattern_moving_between_cities_answer_id_foreign');
		});
		Schema::table('performing_rituals_answer_paths', function(Blueprint $table) {
			$table->dropForeign('performing_rituals_answer_paths_performing_rituals_answer_id_foreign');
		});
		Schema::table('performing_rituals_answer_transfer_patterns', function(Blueprint $table) {
			$table->dropForeign('performing_rituals_answer_transfer_patterns_performing_rituals_answer_id_foreign');
		});
		Schema::table('performing_rituals_answer_trips', function(Blueprint $table) {
			$table->dropForeign('performing_rituals_answer_trips_performing_rituals_answer_id_foreign');
		});
		Schema::table('arrival_transfer_pattern', function(Blueprint $table) {
			$table->dropForeign('arrival_transfer_pattern_arrival_answer_id_foreign');
		});
	}
}