<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArrivalAnswersTable extends Migration {

	public function up()
	{
		Schema::create('arrival_answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('arrival_form_name')->nullable();
			$table->string('stage')->nullable();
			$table->string('time_range')->nullable();
			$table->integer('number_of_pilgrims_coming_to_this_port')->nullable();
			$table->string('access_port')->nullable();
			$table->string('port_name')->nullable();
			$table->string('port_code')->nullable();
			$table->string('starting_point')->nullable();
			$table->string('arrival_point')->nullable();
			$table->string('operation_code')->nullable();
			$table->integer('time_period_for_the_arrival_of_pilgrims_from')->nullable();
			$table->integer('time_period_for_the_arrival_of_pilgrims_to')->nullable();
			$table->integer('target_number_of_pilgrims_per_day_percentage')->nullable();
			$table->integer('target_number_of_pilgrims_per_day_number')->nullable();
			$table->string('transfer_pattern')->nullable();
			$table->string('operating_requirements')->nullable();
			$table->integer('number_of_daily_buses')->nullable();
			$table->integer('number_of_drivers')->nullable();
			$table->integer('regimental_commanders_for_the_target_setting')->nullable();
			$table->integer('number_of_guides')->nullable();
			$table->integer('assistant_regimental_commanders');
			$table->string('Operation_capabilities')->nullable();
			$table->integer('manpower')->nullable();
			$table->integer('devices')->nullable();
			$table->integer('cars')->nullable();
			$table->string('supervision_capabilities')->nullable();
			$table->integer('manpower_supervision')->nullable();
			$table->integer('devices_supervision')->nullable();
			$table->integer('cars_supervision')->nullable();
			$table->string('challenges')->nullable();
			$table->string('solutions')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('arrival_answers');
	}
}