<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TcQuestionAnswer extends Eloquent {

	protected $table = 'tc_question_answers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tc_establishment_id', 'tc_form_id', 'tc_question_id', 'answer');

	public function user()
	{
		return $this->belongsTo('App/Model\TcEstablishment');
	}

	public function question()
	{
		return $this->belongsTo('App/Model\TcQuestion');
	}

}