<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ArrivalTransferPattern extends Model 
{

    protected $table = 'arrival_transfer_pattern';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('arrival_answer_id', 'name', 'number_of_pilgrim');

    public function arrival_answer()
    {
        return $this->belongsTo('App/Model\ArrivalAnswer');
    }

}