<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TcOptionLockup extends Model 
{

    protected $table = 'tc_option_lockup';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tc_establishment_id', 'tc_path_id', 'tc_form_id', 'order');

    public function option()
    {
        return $this->belongsTo('App/Model\TcPath');
    }

    public function form()
    {
        return $this->belongsTo('App/Model\TcForm');
    }

}