<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('discount_id')->nullable();
			$table->string('order_unique_code', 20)->nullable();
			$table->double('pre_order_amount')->nullable();
			$table->double('tax_amount')->nullable();
			$table->float('discount_amount')->nullable();
			$table->double('total_amount')->nullable();
			$table->integer('address_id')->unsigned();
			$table->datetime('date')->nullable();
			$table->enum('status', array('Created', 'Running', 'Delivered', 'Failed'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}