<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStandingsTable extends Migration {

	public function up()
	{
		Schema::create('standings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_id')->unsigned();
			$table->integer('league_id')->unsigned();
			$table->integer('season_id')->unsigned();
			$table->smallInteger('rank');
			$table->smallInteger('points');
			$table->tinyInteger('goals_diff');
			$table->char('form', 5);
			$table->char('status', 10);
			$table->tinyInteger('played');
			$table->smallInteger('wins');
			$table->smallInteger('draws');
			$table->smallInteger('loses');
			$table->smallInteger('goals_for');
			$table->smallInteger('goals_against');
			$table->integer('round_id')->unsigned();
			$table->timestamp('last_updated');
		});
	}

	public function down()
	{
		Schema::drop('standings');
	}
}