<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('activation_code');
			$table->enum('type', array('owner', 'renter', 'marketer', 'employees'));
			$table->double('market_ratio')->nullable();
			$table->string('market_link')->nullable();
			$table->double('market_balance')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}