<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('booking_service', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('booking_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('booking_service', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_user', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee_holidays', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('booking_service', function(Blueprint $table) {
			$table->dropForeign('booking_service_booking_id_foreign');
		});
		Schema::table('booking_service', function(Blueprint $table) {
			$table->dropForeign('booking_service_service_id_foreign');
		});
		Schema::table('booking_service', function(Blueprint $table) {
			$table->dropForeign('booking_service_employee_id_foreign');
		});
		Schema::table('service_user', function(Blueprint $table) {
			$table->dropForeign('service_user_user_id_foreign');
		});
		Schema::table('service_user', function(Blueprint $table) {
			$table->dropForeign('service_user_service_id_foreign');
		});
		Schema::table('employee_holidays', function(Blueprint $table) {
			$table->dropForeign('employee_holidays_user_id_foreign');
		});
	}
}