<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_no', 191);
			$table->integer('user_id');
			$table->integer('status');
			$table->integer('from_warehouse_id');
			$table->integer('to_warehouse_id');
			$table->integer('item');
			$table->double('total_qty');
			$table->double('total_tax');
			$table->double('total_cost');
			$table->double('shipping_cost');
			$table->double('grand_total');
			$table->string('document', 191);
			$table->text('note');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}