<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stores extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'branch_id', 'user_id');

    public function branch()
    {
        return $this->belongsTo('Branches', 'branch_id');
    }

    public function products()
    {
        return $this->hasMany('Products', 'store_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}