<?php

namespace App/Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('phone', 'name', 'email', 'date_of_birth');
	protected $hidden = array('password');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function setting()
	{
		return $this->hasOne('Setting');
	}

	public function posts()
	{
		return $this->belongsToMany('App/Models\Post');
	}

	public function bloodType()
	{
		return $this->belongsToMany('App/Models\BloodType');
	}

	public function notifications()
	{
		return $this->belongsToMany('App/Models\Notification');
	}

}