<?php

namespace App\Models;

class Person extends Eloquent {

	protected $table = 'persons';
	public $timestamps = true;

	public function company()
	{
		return $this->belongsTo('App\Models\Company', 'company_id');
	}

	public function comments()
	{
		return $this->morphMany('App\Models\Comment');
	}

	public function communications()
	{
		return $this->hasMany('App\Models\Communication', 'person_id');
	}

}