<?php

namespace App\Models;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	public function manager()
	{
		return $this->hasOne('App\Models\User', 'user_id');
	}

	public function company()
	{
		return $this->belongsTo('App\Models\Company', 'company_id');
	}

	public function status()
	{
		return $this->hasOne('App\Models\ProjectStatus', 'status_id');
	}

	public function services()
	{
		return $this->belongsToMany('App\Models\Service');
	}

	public function comments()
	{
		return $this->morphMany('App\Models\Comment');
	}

	public function documents()
	{
		return $this->hasMany('App\Models\Document', 'project_id');
	}

	public function invoices()
	{
		return $this->hasMany('App\Models\Invoice', 'project_id');
	}

}