<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Roles_user', function(Blueprint $table) {
			$table->foreign('roles_id')->references('id')->on('Roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Roles_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Permission_roles', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('Permission')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Permission_roles', function(Blueprint $table) {
			$table->foreign('roles_id')->references('id')->on('Roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Taxonomy_data', function(Blueprint $table) {
			$table->foreign('vid')->references('id')->on('Taxonomy_data')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Roles_user', function(Blueprint $table) {
			$table->dropForeign('Roles_user_roles_id_foreign');
		});
		Schema::table('Roles_user', function(Blueprint $table) {
			$table->dropForeign('Roles_user_user_id_foreign');
		});
		Schema::table('Permission_roles', function(Blueprint $table) {
			$table->dropForeign('Permission_roles_permission_id_foreign');
		});
		Schema::table('Permission_roles', function(Blueprint $table) {
			$table->dropForeign('Permission_roles_roles_id_foreign');
		});
		Schema::table('Taxonomy_data', function(Blueprint $table) {
			$table->dropForeign('Taxonomy_data_vid_foreign');
		});
	}
}