<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePessoasFisicasTable extends Migration {

	public function up()
	{
		Schema::create('pessoas_fisicas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nome_mae');
			$table->string('nome_pai');
			$table->string('CPF', 11);
			$table->string('RG');
			$table->date('dt_nascimento');
			$table->string('CNH', 11);
			$table->date('CNH_validade');
			$table->enum('CNH_categoria', array('A', 'B', 'C', 'D', 'E', 'AB', 'AC', 'AD', 'AE'));
			$table->boolean('CNH_exerce_atividade');
			$table->integer('ano_quitacao_militar');
			$table->date('dt_cert_neg_eleitoral');
			$table->date('dt_ver_sit_CPF');
			$table->date('dt_atestado_medico');
			$table->date('dt_cert_nega_inss');
			$table->date('dt_dec_nao_servidor_publico');
			$table->boolean('tem_curso_tran_esc')->default(false);
			$table->date('dt_curso_tran_esc');
			$table->date('dt_ven_curso_tran_esc');
			$table->date('dt_dec_nao_ser_motor');
		});
	}

	public function down()
	{
		Schema::drop('pessoas_fisicas');
	}
}