<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductMainCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('ProductMainCategories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 60);
			$table->boolean('useOwnProduction')->default(0);
			$table->boolean('useFood')->default(0);
			$table->boolean('useNonFood')->default(0);
			$table->boolean('useGastro')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('ProductMainCategories');
	}
}