<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductShopPricesTable extends Migration {

	public function up()
	{
		Schema::create('productShopPrices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shopId');
			$table->boolean('canSell');
			$table->integer('netPrice');
			$table->integer('grossPrice');
			$table->boolean('hasExtraPrice');
			$table->integer('profitMargin');
			$table->integer('minStock')->nullable();
			$table->integer('maxStock')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('productShopPrices');
	}
}