<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone');
			$table->string('website');
			$table->string('kid_code', 10);
			$table->string('type');
			$table->integer('number_of_employees');
			$table->string('connectivity');
			$table->enum('contact_person', array(''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}