<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fees', function(Blueprint $table) {
			$table->foreign('accountId')->references('id')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_amount', function(Blueprint $table) {
			$table->foreign('amount_id')->references('id')->on('amounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_amount', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('program_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('orderId')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('fees', function(Blueprint $table) {
			$table->dropForeign('fees_accountId_foreign');
		});
		Schema::table('product_amount', function(Blueprint $table) {
			$table->dropForeign('product_amount_amount_id_foreign');
		});
		Schema::table('product_amount', function(Blueprint $table) {
			$table->dropForeign('product_amount_product_id_foreign');
		});
		Schema::table('program_products', function(Blueprint $table) {
			$table->dropForeign('program_products_product_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_orderId_foreign');
		});
	}
}