<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('subscriptionplan_id')->unsigned();
			$table->integer('duration');
			$table->float('price');
			$table->date('start_date');
			$table->date('end_date');
			$table->string('paymentstatus', 100);
			$table->integer('paymentmethod');
			$table->text('paymentrefnotes');
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}