<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('first_name');
			$table->string('middle_name');
			$table->string('last_name');
			$table->string('username');
			$table->string('email');
			$table->string('password');
			$table->date('date_of_birth');
			$table->smallInteger('gender');
			$table->string('remember_token');
			$table->string('otp');
			$table->string('social_token');
			$table->string('social_type');
			$table->string('pereferd_lang')->default('en');
			$table->string('country_residence')->default('null');
			$table->integer('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}