<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->longText('brochure');
			$table->integer('sub_category_id');
			$table->integer('out_of_stock');
			$table->integer('trending');
			$table->integer('featured');
			$table->integer('recommended');
			$table->increments('id', true);
			$table->timestamps();
			$table->string('name');
			$table->integer('status');
			$table->integer('category_id');
			$table->integer('brand_id');
			$table->integer('colour_id');
			$table->integer('texture_id');
			$table->integer('size_id');
			$table->string('product_code');
			$table->string('thumbnail');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}