<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElectionDefinitionTable extends Migration {

	public function up()
	{
		Schema::create('ElectionDefinition', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('groupID')->unsigned();
			$table->integer('userID')->unsigned();
			$table->datetime('votingStart');
			$table->datetime('votingEnd');
			$table->text('options');
			$table->enum('status', array('Draft', 'Scheduled', 'Open', 'Review', 'Archived'));
		});
	}

	public function down()
	{
		Schema::drop('ElectionDefinition');
	}
}