<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubmissionScoreTable extends Migration {

	public function up()
	{
		Schema::create('SubmissionScore', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('score')->nullable()->default('0');
			$table->text('comment');
			$table->enum('status', array('Provisional', 'Final'));
			$table->integer('submission_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('SubmissionScore');
	}
}