<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('FormDefinition', function(Blueprint $table) {
			$table->foreign('groupID')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('FormDefinition', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Groups_Users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Groups_Users', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ApplicationSubmission', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('FormDefinition')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SubmissionScore', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SubmissionScore', function(Blueprint $table) {
			$table->foreign('submission_id')->references('id')->on('ApplicationSubmission')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ElectionDefinition', function(Blueprint $table) {
			$table->foreign('groupID')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ElectionDefinition', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BallotSubmission', function(Blueprint $table) {
			$table->foreign('electionID')->references('id')->on('ElectionDefinition')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('FormDefinition', function(Blueprint $table) {
			$table->dropForeign('FormDefinition_groupID_foreign');
		});
		Schema::table('FormDefinition', function(Blueprint $table) {
			$table->dropForeign('FormDefinition_userID_foreign');
		});
		Schema::table('Groups_Users', function(Blueprint $table) {
			$table->dropForeign('Groups_Users_user_id_foreign');
		});
		Schema::table('Groups_Users', function(Blueprint $table) {
			$table->dropForeign('Groups_Users_group_id_foreign');
		});
		Schema::table('ApplicationSubmission', function(Blueprint $table) {
			$table->dropForeign('ApplicationSubmission_form_id_foreign');
		});
		Schema::table('SubmissionScore', function(Blueprint $table) {
			$table->dropForeign('SubmissionScore_user_id_foreign');
		});
		Schema::table('SubmissionScore', function(Blueprint $table) {
			$table->dropForeign('SubmissionScore_submission_id_foreign');
		});
		Schema::table('ElectionDefinition', function(Blueprint $table) {
			$table->dropForeign('ElectionDefinition_groupID_foreign');
		});
		Schema::table('ElectionDefinition', function(Blueprint $table) {
			$table->dropForeign('ElectionDefinition_userID_foreign');
		});
		Schema::table('BallotSubmission', function(Blueprint $table) {
			$table->dropForeign('BallotSubmission_electionID_foreign');
		});
	}
}