<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ApplicationSubmission extends Eloquent {

	protected $table = 'ApplicationSubmission';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('editToken');
	protected $fillable = array('data', 'email', 'status');
	protected $visible = array('data', 'email', 'status');
	protected $hidden = array('editToken');

	public function scores()
	{
		return $this->hasMany('SubmissionScore', 'submission_id');
	}

	public function form()
	{
		return $this->belongsTo('FormDefinition');
	}

}