<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormDefinition extends Eloquent {

	protected $table = 'FormDefinition';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('groupID', 'userID', 'submissionsStart', 'submissionsEnd', 'scoresDue', 'fields', 'status');
	protected $visible = array('groupID', 'userID', 'submissionsStart', 'submissionsEnd', 'scoresDue', 'fields', 'status');

	public function submissions()
	{
		return $this->hasMany('ApplicationSubmission', 'form_id');
	}

}