<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('password');
	protected $fillable = array('email', 'firstName', 'lastName', 'role');
	protected $visible = array('email', 'firstName', 'lastName', 'role');
	protected $hidden = array('password');

	public function groups()
	{
		return $this->belongsToMany('Groups', 'id', 'id');
	}

}