<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->longText('des');
			$table->string('phone');
			$table->integer('city_id');
			$table->integer('category_id')->nullable();
			$table->string('nationality', 255);
			$table->string('whats_number');
			$table->integer('years_skills')->unsigned();
			$table->string('degree', 255);
			$table->enum('type', array('client', 'worker'));
			$table->string('password');
			$table->boolean('activate')->nullable()->default(0);
			$table->boolean('is_busy')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}