<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('amount', 9,2);
			$table->tinyInteger('state')->unsigned();
			$table->string('payment_method');
			$table->datetime('next_payment_at');
			$table->datetime('ends_at');
			$table->integer('subscribable_id')->unsigned();
			$table->string('subscribable_type');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}