<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('acp_navigation', function(Blueprint $table) {
			$table->foreign('parent_link_id')->references('id')->on('acp_navigation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acp_practice_navigation', function(Blueprint $table) {
			$table->foreign('link_id')->references('id')->on('acp_navigation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('acp_navigation', function(Blueprint $table) {
			$table->dropForeign('acp_navigation_parent_link_id_foreign');
		});
		Schema::table('acp_practice_navigation', function(Blueprint $table) {
			$table->dropForeign('acp_practice_navigation_link_id_foreign');
		});
	}
}