<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->string('name')->nullable();
			$table->increments('id');
			$table->string('email')->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password')->nullable();
			$table->string('phone')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->string('remember_token')->nullable();
			$table->timestamp('created_at')->nullable();
			$table->softDeletes();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}