<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Wishlist extends Model 
{

    protected $table = 'wishlists';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getProduct()
    {
        return $this->belongsTo('App\Product');
    }

    public function getCustomer()
    {
        return $this->belongsTo('App\Customer');
    }

}