<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('coupon_code')->unique();
			$table->enum('coupon_type', array(''FirstOrder'', ''CartValue'', ''Reordering'', ''Birthday'', ''Payment'', ''AutoGenerated''));
			$table->string('target_products');
			$table->decimal('minimum_cart_value');
			$table->tinyInteger('discount_type');
			$table->decimal('discount_value');
			$table->decimal('maximum_discount_value');
			$table->integer('validity');
			$table->tinyInteger('status');
			$table->tinyInteger('is_single_use');
			$table->integer('maximum_usage_count');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}