<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeBannersTable extends Migration {

	public function up()
	{
		Schema::create('home_banners', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('title_ar');
			$table->string('description');
			$table->string('description_ar');
			$table->string('banner_url')->nullable();
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('home_banners');
	}
}