<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('project_documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('filename', 512)->nullable();
			$table->string('file_type', 255)->nullable();
			$table->bigInteger('file_size')->nullable();
			$table->string('created_by_user_id')->nullable();
			$table->integer('task_id')->nullable();
			$table->integer('project_id');
		});
	}

	public function down()
	{
		Schema::drop('project_documents');
	}
}