<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationPricesTable extends Migration {

	public function up()
	{
		Schema::create('QuotationPrices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('company_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->string('total');
			$table->string('tax');
			$table->string('discount');
			$table->string('total_after');
			$table->string('payment_methods');
			$table->string('payment_must');
			$table->string('expired_date');
			$table->string('signature');
			$table->string('date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('QuotationPrices');
	}
}