<?php

namespace OrderProduct;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderProduct extends Model 
{

    protected $table = 'order_products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function order()
    {
        return $this->belongsTo('QuotationPrice');
    }

}