<?php

namespace QuotationPrice;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuotationPrice extends Model 
{

    protected $table = 'QuotationPrices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function customer()
    {
        return $this->hasOne('ContactPerson');
    }

    public function company()
    {
        return $this->hasOne('Company');
    }

    public function products()
    {
        return $this->hasManyThrough('Product', 'OrderProduct');
    }

}