<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('driver_id')->unsigned();
			$table->enum('type', array('every_day', 'specific_days', 'one_time'));
			$table->json('work_days')->nullable();
			$table->time('depart_time');
			$table->date('depart_date')->nullable();
			$table->boolean('status')->default(true);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}