<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Station extends Eloquent {

	protected $table = 'stations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function journeys()
	{
		return $this->morphedByMany('Journey');
	}

	public function trips()
	{
		return $this->morphedByMany('Trip');
	}

}